//
//  BlueViewController.swift
//  TabControllerDemo
//
//  Created by Sakib Miazi on 6/6/23.
//

import UIKit

class BlueViewController: UIViewController {
    let blueView = BlueView()
    
    let notificationCenter = NotificationCenter.default
    
    override func loadView() {
        view = blueView
    }
    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = .white
        
        title = "Blue"
        
        //MARK: setting observers...
        observeRed()
        observeGreen()

        //MARK: send hello button...
        blueView.buttonSend.addTarget(self, action: #selector(onButtonSendTapped), for: .touchUpInside)
    }
    
    //MARK: observing red...
    func observeRed(){
        notificationCenter.addObserver(
            self,
            selector: #selector(notificationReceived(notification:)),
            name: .fromRed, object: nil
        )
    }
    
    //MARK: observing green...
    func observeGreen(){
        notificationCenter.addObserver(
            self,
            selector: #selector(notificationReceived(notification:)),
            name: .fromGreen, object: nil
        )
    }
    
    //MARK: handling notifications...
    @objc func notificationReceived(notification: Notification){
        blueView.labelReceived.text = notification.object as! String
    }
    
    //MARK: sending hello to other screens...
    @objc func onButtonSendTapped(){
        notificationCenter.post(
            name: .fromBlue,
            object: "Hello from Blue!"
        )
    }
    

}
